#!/bin/bash
# The concept here is to kill an autossl proc that is taking longer than
# 24 hours. My theory is that sometimes the proc will get stuck, never finish
# and then cause autossl to never run properly.

pgrep autossl_check | while read pid; do
    run_days=$(ps --no-headers -p $pid -o etime | awk '/[0-9]+\-/');
    if [[ ! -z $run_days ]]; then
        proc_name=$(ps --no-headers -p $pid -o args);
        logger "Killing $pid, running for $run_days - $proc_name";
        kill $pid;
    fi
done
