#!/bin/bash
# Shared RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# This tool is used to generate reports of and purge old cPanel backups on shared servers.

############################
## load functions + banners
############################
source /opt/sharedrads/radsfunctions.sh

	if [ "$1" != "--api" ]; then
		clear
	        radsbanner
	fi

###########################
## SCRIPT FUNCTIONS
###########################

function help() {
	  echo
	  echo "This tool can be used to scan/report or automatically remove backups."
	  echo
	  echo "Usage:"
	  echo
          echo "REPORT: backup_scan --list    : per account, lists # of backups and size"
          echo "        backup_scan --full    : full output, lists actual file locations"
	  echo "        backup_scan --total   : total # of backups in # accounts @ `hostname -s`"
	  echo "        backup_scan --api     : Application programming interface (T3 use only)"
	  echo
	  echo "REMOVE: backup_scan --dryrun  : shows users w/ >500MB of backups to be removed"
          echo "        backup_scan --purge   : automatically removes >500MB of backups"
	  echo
          exit 0
}

function getage() {
      	BACKUP_DATE=`/usr/bin/stat $backup --format=%X`
        CURRENT_DATE=$(date +%s)
      	DAYSOLD=`echo $BACKUP_DATE $CURRENT_DATE | awk '{ print ($2 - $1)/86400 }'`
        DAYSOLDINT="`echo $DAYSOLD | cut -d. -f1`"
}


function pleasewait {
echo
echo -n 'Scanning is in progress...'

        while kill -0 "$myPID" 2>/dev/null; do
            sleep 0.3
        echo -n "."
        done
	echo ; echo
}

function overload {
        echo "Pausing due to server conditions...  (Load Average: ${lavg1%%.*}  I/O Wait: $iowait)"
        sleep 10;
}

function loadcheck {
	read lavg1 junk < /proc/loadavg
	iowait=$(/usr/bin/vmstat -S M 2 2 | tail -1 | awk '{print $16}')

            while [[ ${lavg1%%.*} -gt 20 ]] || [[ $iowait -gt 40 ]] ;
            do
              	overload
                read lavg1 junk < /proc/loadavg
                iowait=$(/usr/bin/vmstat -S M 2 2 | tail -1 | awk '{print $16}')
            done

}

#############################
## CHECK ARGUMENTS RECEIVED
#############################

                if [ "$1" == "--help" ]; then
		help
                fi

                if [ -z "$1" ]; then
                help
                fi


                if [ "$1" == "--full" ]; then
			echo "Please wait while I search the /home/ partition for any archived cPanel backups."
		fi

                if [ "$1" == "--list" ]; then
                        echo "Please wait while I search the /home/ partition for any archived cPanel backups."
			echo " tip: to display results w/full path & directory listings, add the --full flag"
                fi


##########################
##SET A UNIQUE SESSION ID
##########################

SESSIONID=`date +%s`
RAWLIST="/tmp/.bkpscan.$SESSIONID.raw"
USERLIST="/tmp/.bkpscan.$SESSIONID.user"
UNIQUSERLIST="/tmp/.bkpscan.$SESSIONID.uniquser"

#########################################################
## lets list out the directories and wait for completion
##########################################################

	if [ "$1" != "--api" ];	then
		ls /home/*/backup-*.tar.gz -la | sort -nk5 > $RAWLIST &
		myPID=$!
		pleasewait
	else
                ls /home/*/backup-*.tar.gz -la | sort -nk5 > $RAWLIST
	fi

######################################
## GET AND SORT UNIQUE USERS
######################################

for user in `cat $RAWLIST | awk '{print $9}' | awk -F_ '{print $3}' | cut -d. -f1`
 	do
		NOTHERE=FALSE
		id $user >> /dev/null || NOTHERE=TRUE

	if [ "$NOTHERE" == "FALSE" ]; then
		echo $user
	fi

done  > $USERLIST

#cleanup user list, make unique
cat $USERLIST | sort | uniq > $UNIQUSERLIST

for uniquser in `cat $UNIQUSERLIST`
	do

                if [ "$1" == "--api" ]; then
 	                BACKUPCOUNT=`grep "^$uniquser$" $USERLIST | wc -l`
                   	TOTALDISKMB=`grep \/$uniquser\/ $RAWLIST | awk '{ TOTAL += $5 } END { print TOTAL/1024/1024 }' | cut -d. -f1`
                        echo "$uniquser,$BACKUPCOUNT,$TOTALDISKMB"
			continue
		fi

                if [ "$1" == "--total" ]; then
                       	BACKUPCOUNT=`cat $USERLIST | wc -l`
                       	TOTALDISKMB=`cat $RAWLIST | awk '{ TOTAL += $5 } END { print TOTAL/1024/1024 }'`
			UNIQUSERS=`cat $UNIQUSERLIST | wc -l`
                       	echo "[*] Found $BACKUPCOUNT cPanel backups in $UNIQUSERS accounts occupying a total of $TOTALDISKMB MB."
			echo
			exit 0
		fi


#############################################
## SHOW WHAT WE WOULD PURGE, NO ACTION TAKEN
#############################################

		if [ "$1" == "--dryrun" ]; then
			BACKUPCOUNT=`grep "^$uniquser$" $USERLIST | wc -l`
                        TOTALDISKMB=`grep \/$uniquser\/ $RAWLIST | awk '{ TOTAL += $5 } END { print TOTAL/1024/1024 }'`
			TOTALDISKINT=`echo $TOTALDISKMB | cut -d. -f1`

		for backup in `grep \/$uniquser\/ $RAWLIST | awk '{print $9}'`
			do
				if [ "$TOTALDISKINT" -gt "500" ]; then
					echo "[*] $uniquser has more than 500MB of backups."

					if [ -f "$backup" ]; then
						getage

							if [ "$DAYSOLDINT" -gt "7" ]; then
								echo "[*] Large backup found >7 days old. This would be removed."
								echo "nice -n 19 ionice -c2 -n7 rm -rfv $backup"
								continue
							else
								echo "[*] Large backup found, but is not yet 7 days old - skipping."
								continue
							fi
					else
						echo "ERROR: could not find $backup"
						continue
					fi
				else
					continue
				fi
		done

		fi

#########################################
## LETS ACTUALLY PURGE OLD BACKUPS >500M
#########################################

		if [ "$1" == "--purge" ]; then
			BACKUPCOUNT=`grep "^$uniquser$" $USERLIST | wc -l`
                        TOTALDISKMB=`grep \/$uniquser\/ $RAWLIST | awk '{ TOTAL += $5 } END { print TOTAL/1024/1024 }'`
			TOTALDISKINT=`echo $TOTALDISKMB | cut -d. -f1`

		for backup in `grep \/$uniquser\/ $RAWLIST | awk '{print $9}'`
			do
				if [ "$TOTALDISKINT" -gt "500" ]; then
					echo "[*] $uniquser has more than 500MB of backups."

					if [ -f "$backup" ]; then
						getage

							if [ "$DAYSOLDINT" -gt "7" ]; then
								loadcheck #check to make sure the server is stable before removal
								echo "[*] Large backup found, automatically removing >7 day old backup."
								logger -t IMH-backups "$TOTALDISKMB MB of backup(s) found and removed: $backup "
								nice -n 19 ionice -c2 -n7 rm -rfv $backup
								continue
							else
								echo "[*] Large backup found, but is not yet 7 days old - skipping."
								continue
							fi
					else
						echo "ERROR: could not find $backup"
						continue
					fi
				else
					continue
				fi
		done

		fi


###########################
## FULL REPORT, NO ACTION
###########################

		if [ "$1" == "--full" ]; then

                        BACKUPCOUNT=`grep "^$uniquser$" $USERLIST | wc -l`
                        TOTALDISKMB=`grep \/$uniquser\/ $RAWLIST | awk '{ TOTAL += $5 } END { print TOTAL/1024/1024 }'`
                        echo "[*] Found the following $BACKUPCOUNT archived cPanel backups in /home/$uniquser occupying a total of $TOTALDISKMB MB:"
			grep \/$uniquser\/ $RAWLIST
        	        echo
	                echo "-----------------------------------------------------------------------------------------------------------"
	               	echo
		fi

                if [ "$1" == "--list" ]; then
                        BACKUPCOUNT=`grep "^$uniquser$" $USERLIST | wc -l`
                        TOTALDISKMB=`grep \/$uniquser\/ $RAWLIST | awk '{ TOTAL += $5 } END { print TOTAL/1024/1024 }' | cut -d. -f1`
                        echo "[*] Found $BACKUPCOUNT cPanel backups in /home/$uniquser occupying a total of $TOTALDISKMB MB."
		fi

done


#cleanup our mess
rm -f $RAWLIST
rm -f $USERLIST
rm -f $UNIQUSERLIST


	if [ "$1" != "--api" ]; then
		echo
		echo "Scanning complete."
		echo
	fi
