"""Removes large cPanel files from ~userna5/tmp"""
from guds_modules.base import ModuleBase

REGEX = r".*\/Cpanel_Form_file[.]upload[.][0-9a-zA-Z]+$"


class Module(ModuleBase):
    """Removes large cPanel files from ~userna5/tmp"""

    def run_module(self, homedir):
        if file_list := self.find(
            f"{homedir}/tmp",
            prune_mail=False,
            regex=REGEX,
            mtime="+3",
            type="f",
        ):
            self.delete_items(file_list)
        return {}  # no email
