"""Removes day-old partial backups (zi*)"""
from guds_modules.base import ModuleBase


class Module(ModuleBase):
    """Removes day-old partial backups (zi*)"""

    def run_module(self, homedir):
        if backup_list := self.find(
            homedir, type='f', regex=r".*\/zi[0-9a-zA-Z]{6}$", mtime="+1"
        ):
            self.delete_items(backup_list)
        return {}  # no email
