#!/bin/bash
# this script checks the available disk space and sends in move tickets if needed

SPACE=$(/bin/df / -B 1073741824 | awk '$NF ~ /^\/$/ {print $2}')
AVAIL=$(/bin/df / -B 1073741824 | awk '$NF ~ /^\/$/ {print $4}')

if [ $SPACE -gt 10000 ]; then
    THRESHOLD=200
else
    THRESHOLD=$(echo "$SPACE * 3 / 100" | bc)
fi


if [ $AVAIL -lt $THRESHOLD ]; then
    RECLAIM=$(echo "${AVAIL} - ${THRESHOLD}" | bc)
    echo Generating disk move tickets for largest accounts...
    /opt/sharedrads/move_generator.py -d -t$RECLAIM
fi
