#!/usr/bin/perl
# encoding: utf-8
#
# author: Kyle Yetter
#

package IMH::MountPoint;

use strict;
use warnings;
use File::Basename;
require Exporter;

our @ISA = qw( Exporter );

our %EXPORT_TAGS = ( 'all' => [ qw( is_mount_point ) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( is_mount_point );

our $VERSION = '0.1';

sub is_mount_point {
  my $path = shift or die "need a directory argument";
  unless ( -d $path ) { return 0; }
  my $path_device   = ( stat( $path ) )[ 0 ];
  my $parent_device = ( stat( dirname( $path ) ) )[ 0 ];

  return( $path_device != $parent_device );
}


1;
__END__
=head1 NAME

IMH::MountPoint - Utilities to check whether a directory is a mount point

=head1 SYNOPSIS

  use IMH::MountPoint;

  unless ( is_mount_point( "/backup" ) ) {
    system( "mount", "/backup" );
  }

=head1 AUTHOR

Kyle Yetter, E<lt>kyley@inmotionhosting.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011 by Kyle Yetter.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.10.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
