package IMH::Terminal;

use strict;
use warnings;

use Term::ANSIColor;
require Exporter;

our @ISA = qw(Exporter);


our %EXPORT_TAGS = ( 'all' => [ qw(
  screen_size screen_width screen_height c bleach clen ljust rjust center $bleach
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( screen_size screen_width screen_height c bleach clen ljust rjust center );

our $VERSION = '0.01';

our $bleach      = !-t STDOUT;


sub screen_size {
  my @size = ( $ENV{'COLUMNS'} || 80, $ENV{'LINES'} || 22 );
  my $tiocgwinsz = 0x5413;

  eval {
    my $data = '';
    if ( ioctl( STDERR, $tiocgwinsz, $data ) >= 0 ) {
      my ( $height, $width ) = unpack( "SSSS", $data );
      $size[ 1 ] = $height if $height >= 0;
      $size[ 0 ] = $width  if $width  >= 0;
    }
  };
  return @size;
}

sub screen_width {
  my ( $w, $h ) = screen_size;
  return( 0 + $w );
}

sub screen_height {
  my ( $w, $h ) = screen_size;
  return( 0 + $h );
}


sub c($$) {
  my ( $str, $style ) = @_;
  defined( $str ) or $str = '';
  if ( $style && !$bleach ) {
    $str = colored( $str, $style );
  }
  return $str;
}

sub bleach($) {
  my ( $colored ) = @_;
  defined( $colored ) or $colored = '';
  $colored =~ s(\033\[[^a-z]*[a-z])()g;
  return $colored;
}

sub clen($) {
  return length( bleach( $_[ 0 ] ) );
}

sub ljust($$) {
  my ( $string, $width ) = @_;
  defined( $string ) or $string = '';

  my $len = clen( $string );
  return $string if $width <= $len;

  my $padding = $width - $len;

  return( $string . ( ' ' x $padding ) );
}

sub rjust($$) {
  my ( $string, $width ) = @_;
  defined( $string ) or $string = '';

  my $len = clen( $string );
  return $string if $width <= $len;

  my $padding = $width - $len;

  return( ( ' ' x $padding ) . $string );
}


sub center($$) {
  my ( $string, $width ) = @_;
  defined( $string ) or $string = '';

  my $len = clen( $string );
  return $string if $width <= $len;

  my $padding = $width - $len;
  my $left = int( $padding / 2 );
  my $right = $left + $padding % 2;

  return( ( ' ' x $left ) . $string . ( ' ' x $right ) );
}


1;
__END__
