#!/bin/bash

# Fix to kill/resolve orphaned PHP-FPM processes

SUPERVISORCTL="/opt/imh-python/bin/supervisorctl -c /opt/ngxconf/supervisord/supervisord.conf"


NAG_OK=0
NAG_WARN=1
NAG_CRIT=2

cmd=$1
output=$(ps -ef | grep -i "php-fpm:" | grep -v "grep" | awk '$3==1{print $9,$10,$11}')
pids=$(ps -ef | grep -i "php-fpm:" | grep -v "grep" | awk '$3==1{print $2}')
orphaned_count=0

# Verify supervisord is responsive
if ! $SUPERVISORCTL version > /dev/null  # to /dev/null to prevent unneeded spam
then
  echo "Couldn't run 'supervisorctl status all'! Orphans would not be able to restart without supervisord."
  echo "Ensure supervisord is working before attempting fix."
  echo -n "Error: "
  $SUPERVISORCTL version
  exit $NAG_CRIT
fi


# Count how many lines there are to see if there's an issue/to report a number to Icinga
while read line
do
  if [[ -n $line ]]  # If the line is blank ignore it
  then
    let 'orphaned_count=orphaned_count+1'
  fi
done < <(echo "$output")

# If any pool or master is orphaned throw a crit or try to fix it
if [[ $orphaned_count -gt 0 ]]
then
  echo -n "Killing"
  while read pid
  do
    kill -9 $pid
    echo -n " $pid"
  done < <(echo "$pids")
  echo ""
fi

if [[ "$cmd" == "fix2" ]]  # Second pass cleans up any remaining php-fpm pools orphaned by the previous round killing orphaned masters
then
  sleep 5
  echo "Attempting to start all PHP-FPM masters"
  if $SUPERVISORCTL start all
  then
    echo "Started all php-fpm masters through supervisorctl"
  else
    echo "Failed to issue supervisorctl command to restart php-fpm masters - PHP is down on this server! Is supervisord responding?"
    exit $NAG_CRIT
  fi
  exit $?
else # Clean up some cPanel files and Run second pass
  # Remove any php-fpm.yaml userdata files
  echo "Removing php-fpm files..."
  find /var/cpanel/userdata/*/ -name "*.php-fpm.yaml" -print -delete

  # Remove any cpanel php-fpm config files
  echo "Removing php-fpm conf files..."
  find /opt/cpanel/ea-php*/root/etc/php-fpm.d/ -name "*.conf" -print -delete

  $0 fix2
  exit $?
fi
