#!/bin/bash

USER=$1
SESSIONID=`date +%s`
CHILDACCTS=`/bin/grep -rl OWNER=$USER /var/cpanel/users|cut -d/ -f5`

if [ -z $1 ]; then

# No reseller inputted, display top resellers sorted by cumulative CP #

touch /tmp/sumrescp.$SESSIONID
touch /tmp/rescp.$SESSIONID

sa -cm |awk '{print $1,$6}' > /tmp/sadata.$SESSIONID

cat /tmp/sadata.$SESSIONID| while read line; do
 ruser=$(echo $line|awk '{print $1}')
 rusercp=$(echo $line|sed 's/[A-Za-z]*//g'|awk '{print $NF}')
 rparent=$(grep OWNER /var/cpanel/users/$ruser 2>/dev/null|cut -d= -f2)
 echo "$rparent $rusercp" >> /tmp/rescp.$SESSIONID
done

awk '{arr[$1]+=$2;} END {for (i in arr) print i, arr[i]}' /tmp/rescp.$SESSIONID > /tmp/sumrescp.$SESSIONID

 echo
 echo -e "Top 15 resellers sorted by CP used so far today:"
 echo
cat /tmp/sumrescp.$SESSIONID |egrep -v "root|nobody|mailnull|inmotion|cpanellogin|clamav|dovenull|nagios|cpanel" |sort -nk2 |tail -15 |tac|sed 's/$/cp/'|column -t
echo

else

 ###############################################
 # Showing cumulative CP for specific reseller #
 ###############################################

 if [[ `grep OWNER /var/cpanel/users/$USER -s` = "OWNER=inmotion" ]]; then
   ALLACCTS=$( echo "$CHILDACCTS"; echo  "$USER")
   echo
   echo -e "  Cumulative CP usage of reseller: $USER"
   echo -ne "  Total # of child accounts: "
   echo "$CHILDACCTS"|wc -l
   echo -ne "  Total CP used today (`date --date="today"| awk '{print $2,$3}'`): "
   sa -cm |egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo
   echo

   echo "Historical cumulative CPU usage"

   DAY1=$(echo "`date +"%b/%d" --date="-1 days"`")
   echo -n "     $DAY1 :: "
   zcat /var/log/sa/rads/$DAY1/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo

   DAY2=$(echo "`date +"%b/%d" --date="-2 days"`")
   echo -n "     $DAY2 :: "
   zcat /var/log/sa/rads/$DAY2/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo

   DAY3=$(echo "`date +"%b/%d" --date="-3 days"`")
   echo -n "     $DAY3 :: "
   zcat /var/log/sa/rads/$DAY3/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo

   DAY4=$(echo "`date +"%b/%d" --date="-4 days"`")
   echo -n "     $DAY4 :: "
   zcat /var/log/sa/rads/$DAY4/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo

   DAY5=$(echo "`date +"%b/%d" --date="-5 days"`")
   echo -n "     $DAY5 :: "
   zcat /var/log/sa/rads/$DAY5/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo

   DAY6=$(echo "`date +"%b/%d" --date="-6 days"`")
   echo -n "     $DAY6 :: "
   zcat /var/log/sa/rads/$DAY6/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"
   echo

   DAY7=$(echo "`date +"%b/%d" --date="-7 days"`")
   echo -n "     $DAY7 :: "
   zcat /var/log/sa/rads/$DAY7/21-avg.gz | egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{s+=$6} END {printf "%.0f", s}'
   echo -ne "cp"

   echo
   echo
   echo "Displaying top 20 child accounts sorted by CP for reseller ($USER): "
   echo
   sa -cm |egrep -w `echo $ALLACCTS|sed ':a;N;$!ba;s/\n/ /g'|sed 's# #|#g'`|awk '{print "     "$1,$6}'|head -20|column -t
   echo

 else
   echo

 # Display error/help message
  echo "rescp.sh - A script made to help identify reseller accounts that are consuming a large amount of CP"
  echo
  echo "Usage:"
  echo "   Option 1.) Run script with no arguments (calculates cumulative CP usage for reseller users across the server)"
  echo "   Option 2.) Run script with a reseller username (see children with the highest CP)"
  echo
 fi

fi

# Remove temporary files
rm -f /tmp/rescp.$SESSIONID
rm -f /tmp/sumrescp.$SESSIONID
rm -f /tmp/sadata.$SESSIONID
