#!/opt/imh-python/bin/python3
import pytest
import sys
import os
from datetime import datetime, timedelta

radsdir = os.path.abspath('%s/..' % os.path.dirname(os.path.realpath(__file__)))
sys.path.append(radsdir)
print(sys.path)
# pylint: disable=unused-import
from autosuspend import Autosuspend, User
import autosuspend


@pytest.fixture(scope="module")
def users():
    users = {
        'bare_user': User(),
        'old_warning': User(
            name='warnin5',
            todays_cp=750,
            warnings=[(datetime.now() - timedelta(days=90)).strftime("%s")],
        ),
        'low_slow': User(
            todays_cp='41',
            historic_cp=['41', '50', 44, 43.1, 44, 44, 44, 41],
        ),
        'int_suspensions': User(suspensions=['1386795219']),
        'mixed_supensions': User(
            suspensions=[1386795219, '1386795212', 1386795218.2]
        ),
        'bad_user': User(
            name='ajerk5',
            todays_cp=80.1,
            historic_cp=[41.1, 44.1, 40.1, 65, 100],
            warnings=[(datetime.now() - timedelta(seconds=90)).strftime("%s")],
            suspensions=[(datetime.now() - timedelta(days=90)).strftime("%s")],
        ),
        'high_usage_today': User(
            name='victim5',
            todays_cp=750,
            warnings=[(datetime.now() - timedelta(seconds=90)).strftime("%s")],
            historic_cp=[41.1],
        ),
        'high_usage_old_warning': User(
            warnings=[(datetime.now() - timedelta(days=90)).strftime("%s")],
        ),
    }
    return users


class TestUser:
    def test_last_suspension(self, users):
        correct_date = datetime.fromtimestamp(1386795219)
        assert users['bare_user'].last_suspension == None
        assert users['int_suspensions'].last_suspension == correct_date
        assert users['mixed_supensions'].last_suspension == correct_date


class TestUserTimeDeltas:
    def test_warned_within(self, users):
        delta = timedelta(days=2)
        assert users['bad_user'].warned_within(delta) == True
        assert users['bare_user'].warned_within(delta) == False
        assert users['high_usage_today'].warned_within('2d') == True
        assert users['old_warning'].warned_within('2d') == False

    def test_suspended_longer_ago(self, users):
        assert users['bare_user'].suspended_longer_ago('2d') == True
        assert users['high_usage_today'].suspended_longer_ago('2d') == True
        assert users['bare_user'].suspended_longer_ago('2d') == True
